package idemia.ipv;

import lombok.Data;

import java.util.Properties;

@Data
public class Configuration {

    private final Integer port;
    private final String secret;
    private final String headerHmac;
    private final String urlPath;

    public Configuration(Properties prop) {
        this.secret = prop.getProperty("secret");
        this.headerHmac = prop.getProperty("headerHmac");
        this.port = Integer.valueOf(prop.getProperty("port"));
        this.urlPath = prop.getProperty("urlPath");

    }
}
